package editor;

import game.BusyPanel;
import game.PackerUnpacker;
import game.PonyPanel;

import java.awt.BorderLayout;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MainEditorPanel extends JPanel {
	
	
	private JTextField bgmTextArea;
	private JTextField levelName;
	private JCheckBox rainCheckbox;
	private RoomList roomList;
	private JScrollPane roomScrollPane;
	private JScrollPane characterScrollPane;
	private CharacterList characterList;
	
	private JFrame frame;
	
	final static boolean shouldFill = true;
    final static boolean shouldWeightX = true;
    final static boolean RIGHT_TO_LEFT = false;
	public MainEditorPanel(JFrame theParent) {
		
		frame = theParent;
		frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		frame.addWindowListener(new WindowListener() {
			
			@Override
			public void windowOpened(WindowEvent arg0) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void windowIconified(WindowEvent arg0) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void windowDeiconified(WindowEvent arg0) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void windowDeactivated(WindowEvent arg0) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void windowClosing(WindowEvent arg0) {
				quit();
			}
			
			@Override
			public void windowClosed(WindowEvent arg0) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void windowActivated(WindowEvent arg0) {
				// TODO Auto-generated method stub
				
			}
		});
		
		
		GridBagLayout gbLayout = new GridBagLayout();
		GridBagConstraints gbConstraints = new GridBagConstraints();
		
		this.setLayout(new BorderLayout());
		
		JPanel lowerButtons = new JPanel(new GridLayout(1, 4));
		
		JButton saveButton = new JButton("Save...");
		saveButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				save();
			}
		});
		lowerButtons.add(saveButton);
		
		JButton loadButton = new JButton("Load...");
		loadButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				load(true, null);
			}
		});
		lowerButtons.add(loadButton);
		
		JButton newButton = new JButton("New");
		newButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				newFile();
			}
		});
		lowerButtons.add(newButton);
		
		
		JButton exitButton = new JButton("Exit");
		exitButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				quit();
			}
		});
		lowerButtons.add(exitButton);
		
		
		this.add(lowerButtons, BorderLayout.SOUTH);
		
		
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(gbLayout);
		
		
		JTabbedPane tabbedPane = new JTabbedPane();
		
		roomList = new RoomList(this);
		roomScrollPane = new JScrollPane(roomList);
		roomScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		roomScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		roomScrollPane.setPreferredSize(new Dimension(350, 350));
		roomScrollPane.setMaximumSize(new Dimension(350, 350));
		roomScrollPane.setMinimumSize(new Dimension(350, 350));
		roomScrollPane.setSize(new Dimension(350, 350));
		
		
		gbConstraints.gridwidth = GridBagConstraints.REMAINDER;
		gbConstraints.gridheight = 2;
		gbConstraints.fill = GridBagConstraints.HORIZONTAL;
		gbConstraints.weightx = 1.0;
		gbConstraints.weighty = 1.0;
		gbConstraints.gridx = 0;
		gbConstraints.gridy = 0;
		
		//gbLayout.setConstraints(mainPanel, gbConstraints);
		
		tabbedPane.add(roomScrollPane, "Rooms");
		
		
		characterList = new CharacterList();
		characterScrollPane = new JScrollPane(characterList);
		characterScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		characterScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		characterScrollPane.setPreferredSize(new Dimension(350, 350));
		characterScrollPane.setMaximumSize(new Dimension(350, 350));
		characterScrollPane.setMinimumSize(new Dimension(350, 350));
		characterScrollPane.setSize(new Dimension(350, 350));
		
		tabbedPane.add(characterScrollPane, "Characters");
		
		
		mainPanel.add(tabbedPane, gbConstraints);
		
		
		JPanel otherControlsPanel = new JPanel();
//		otherControlsPanel.setBackground(Color.yellow);
		
		
		
		otherControlsPanel.setLayout(new GridLayout(5, 1));//new BoxLayout(this, BoxLayout.Y_AXIS)
		
//		otherControlsConstraints.weightx = 1.0;
//		otherControlsConstraints.weighty = 1.0;
//		otherControlsConstraints.gridx = 0;
//		otherControlsConstraints.gridy = 0;
//		otherControlsConstraints.anchor = GridBagConstraints.FIRST_LINE_START;
//		otherControlsConstraints.gridwidth = 4;
		
		JPanel lowerPanelRowOne = new JPanel(new GridLayout(1, 2));
//		JButton setStartRoomButton = new JButton("Set starting room");
//		setStartRoomButton.addActionListener(new ActionListener() {
//			@Override
//			public void actionPerformed(ActionEvent e) {
//				openStartRoomSelectionWizard();
//			}
//		});
//		
//		lowerPanelRowOne.add(setStartRoomButton);
		
//		otherControlsConstraints.gridx = 4;
//		otherControlsConstraints.gridy = 0;
//		otherControlsConstraints.anchor = GridBagConstraints.FIRST_LINE_END;
//		otherControlsConstraints.gridwidth = 6;
		
		JPanel showHelpPanel = new JPanel(new FlowLayout());
		JButton showHelpButton = new JButton("Tutorial Videos...");
		showHelpButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				openBrowserToTutorialsScreen("https://www.youtube.com/playlist?list=PLYN-6Fdr9Mpqwg2jBON_jpP0MgYN_vD4q");
			}
		});
		showHelpPanel.add(showHelpButton);
		lowerPanelRowOne.add(showHelpPanel);
		
		JPanel showVersionsPanel = new JPanel(new FlowLayout());
		JButton showVersionsButton = new JButton("Version History...");
		showVersionsButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				showVersionHistoryPopup();
			}
		});
		showVersionsPanel.add(showVersionsButton);
		lowerPanelRowOne.add(showVersionsPanel);
		
		
		otherControlsPanel.add(lowerPanelRowOne);
		otherControlsPanel.add(new JPanel());  //filler
		
//		otherControlsPanel.add(new JPanel(), otherControlsConstraints);//filler
		
		JPanel lowerPanelRowThree = new JPanel(new FlowLayout());
		lowerPanelRowThree.add(new JLabel("Level Name:  "));
		levelName = new JTextField(20);
		lowerPanelRowThree.add(levelName);
		otherControlsPanel.add(lowerPanelRowThree);
		
		JPanel lowerPanelRowFour = new JPanel(new FlowLayout());
		
//		otherControlsConstraints.gridx = 0;
//		otherControlsConstraints.gridy = 1;
//		otherControlsConstraints.gridwidth = 2;
//		otherControlsConstraints.anchor = GridBagConstraints.LINE_START;
		lowerPanelRowFour.add(new JLabel("Background Music:"));
		
		bgmTextArea = new JTextField();
		bgmTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
		bgmTextArea.setSize(new Dimension(160, 21));
		bgmTextArea.setPreferredSize(new Dimension(160, 21));
		bgmTextArea.setEditable(false);
		bgmTextArea.setText("default");
		bgmTextArea.setAlignmentX(JComponent.RIGHT_ALIGNMENT);
//		otherControlsConstraints.gridx = 2;
//		otherControlsConstraints.gridy = 1;
//		otherControlsConstraints.gridwidth = 5;
//		otherControlsConstraints.anchor = GridBagConstraints.CENTER;
		lowerPanelRowFour.add(bgmTextArea);
		
		JButton bgmBrowseButton = new JButton("Browse...");
//		otherControlsConstraints.gridx = 7;
//		otherControlsConstraints.gridy = 1;
//		otherControlsConstraints.gridwidth = 3;
//		otherControlsConstraints.anchor = GridBagConstraints.LINE_END;
		bgmBrowseButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				JOptionPane.showMessageDialog(null, "<html>Please:  show respect to the wishes of those of us who make music.<br>I realize part of the appeal of this software is being able to put brony-tunes to a video game.<br>Still, please don't use music without the composer's permission!<br><br>(I got Glaze's permission to use Rainbow Factory, mind!)</html>", "Don't use music without permission!", JOptionPane.WARNING_MESSAGE);
				retrieveSoundFile(bgmTextArea, frame);
			}
		});
		lowerPanelRowFour.add(bgmBrowseButton);
		
		
		otherControlsPanel.add(lowerPanelRowFour);
		
		
		
		JPanel lowerPanelRowFive = new JPanel(new FlowLayout());
		
		rainCheckbox = new JCheckBox("rain?");
//		otherControlsConstraints.gridx = 0;
//		otherControlsConstraints.gridy = 2;
//		otherControlsConstraints.gridwidth = 2;
//		otherControlsConstraints.anchor = GridBagConstraints.LAST_LINE_START;
		lowerPanelRowFive.add(rainCheckbox);
		
//		JButton charactersButton = new JButton("Characters...");
//		otherControlsConstraints.gridx = 2;
//		otherControlsConstraints.gridy = 2;
//		otherControlsConstraints.gridwidth = 8;
//		otherControlsConstraints.anchor = GridBagConstraints.LAST_LINE_END;
//		lowerPanelRowFive.add(charactersButton);
		
//		JButton helpButton = new JButton("Tutorial Videos...");
//		helpButton.addActionListener(new ActionListener() {
//			
//			@Override
//			public void actionPerformed(ActionEvent arg0) {
//				if(!Desktop.isDesktopSupported()) {
//					
//					JOptionPane.showMessageDialog(null, "<html>Sorry, but on your computer, there's no feature for opening browser windows.<br>" +
//							"You'll need to open one yourself and go to <a href='https://www.youtube.com/watch?v=eumGYtsafxA'>https://www.youtube.com/watch?v=eumGYtsafxA</a>.</html>");
//					
//				} else {
//					Desktop desktop = Desktop.getDesktop();
//			        if (desktop.isSupported(Desktop.Action.BROWSE)) {
//			        	try {
//			        		desktop.browse(new URI("https://www.youtube.com/watch?v=eumGYtsafxA"));
//			        	} catch(Exception e) {
//			        		JOptionPane.showMessageDialog(null, PonyPanel.formatStackTrace(e),"Error while trying to navigate to web page", JOptionPane.ERROR_MESSAGE);
//			        	}
//			        } else {
//			        	JOptionPane.showMessageDialog(null, "<html>Sorry, but on your computer, there isn't a feature for opening browser windows.<br>" +
//								"You'll need to open one yourself and go to <a href='https://www.youtube.com/watch?v=eumGYtsafxA'>https://www.youtube.com/watch?v=eumGYtsafxA</a>.</html>");
//			        }
//				}
//				return;
//				
//			}
//		});
//		lowerPanelRowFive.add(rainCheckbox);
		
		lowerPanelRowFive.add(new JPanel());
		
		otherControlsPanel.add(lowerPanelRowFive);
		
		
		gbConstraints.gridwidth = GridBagConstraints.REMAINDER;
		gbConstraints.gridheight = 1;
//		gbConstraints.weighty = 1;
		gbConstraints.gridx = 0;
		gbConstraints.gridy = 2;
		
		//gbLayout.setConstraints(mainPanel, gbConstraints);
		
		mainPanel.add(otherControlsPanel, gbConstraints);
		
		this.add(mainPanel, BorderLayout.CENTER);
		
	}
	
	
	 public static void addComponentsToPane(Container pane) {
	        if (RIGHT_TO_LEFT) {
	            pane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
	        }

	        JButton button;
		pane.setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		if (shouldFill) {
		//natural height, maximum width
		c.fill = GridBagConstraints.HORIZONTAL;
		}

		button = new JButton("Button 1");
		if (shouldWeightX) {
		c.weightx = 0.5;
		}
		c.fill = GridBagConstraints.HORIZONTAL;
		c.gridx = 0;
		c.gridy = 0;
		pane.add(button, c);

		button = new JButton("Button 2");
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 0.5;
		c.gridx = 1;
		c.gridy = 0;
		pane.add(button, c);

		button = new JButton("Button 3");
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 0.5;
		c.gridx = 2;
		c.gridy = 0;
		pane.add(button, c);

		button = new JButton("Long-Named Button 4");
		c.fill = GridBagConstraints.HORIZONTAL;
		c.ipady = 40;      //make this component tall
		c.weightx = 0.0;
		c.gridwidth = 3;
		c.gridx = 0;
		c.gridy = 1;
		pane.add(button, c);

		button = new JButton("5");
		c.fill = GridBagConstraints.HORIZONTAL;
		c.ipady = 0;       //reset to default
		c.weighty = 1.0;   //request any extra vertical space
		c.anchor = GridBagConstraints.PAGE_END; //bottom of space
		c.insets = new Insets(10,0,0,0);  //top padding
		c.gridx = 1;       //aligned with button 2
		c.gridwidth = 2;   //2 columns wide
		c.gridy = 2;       //third row
		pane.add(button, c);
	    }
	
	
	
	/*
	public MainEditorPanel() {
		
		
		int zero = 1;
		if(0 == zero) {
			addComponentsToPane(this);
			return;
		}
		
		
		
		GridBagLayout gbLayout = new GridBagLayout();
		GridBagConstraints gbConstraints = new GridBagConstraints();
		
//		this.setLayout(new BorderLayout());
//		
//		JButton lowerButtonPlaceholder = new JButton("Lower Area Placeholder");
//		
//		this.add(lowerButtonPlaceholder, BorderLayout.SOUTH);
		
		
		
		JPanel mainPanel = this; //new JPanel();
		mainPanel.setLayout(gbLayout);
		
		
		JButton roomsButtonPlaceholder = new JButton("placeholder for rooms");
		roomsButtonPlaceholder.setBackground(Color.red);
		
		gbConstraints.gridwidth = 10;
		gbConstraints.gridheight = 5;
		gbConstraints.fill = GridBagConstraints.VERTICAL;
		gbConstraints.weightx = 0.5;
		gbConstraints.weighty = 0.5;
		gbConstraints.gridx = 0;
		gbConstraints.gridy = 0;
		
		//gbConstraints.anchor = GridBagConstraints.FIRST_LINE_START;
		
		//gbLayout.setConstraints(mainPanel, gbConstraints);
		
		mainPanel.add(roomsButtonPlaceholder, gbConstraints);
		
		
		JPanel otherControlsPanel = mainPanel; //new JPanel();
//		otherControlsPanel.setBackground(Color.yellow);
		
		GridBagLayout otherControlsLayout = new GridBagLayout();
		GridBagConstraints otherControlsConstraints = new GridBagConstraints();
		
		otherControlsPanel.setLayout(otherControlsLayout);
		
		otherControlsConstraints.weightx = 0.5;
		otherControlsConstraints.weighty = 0.5;
		
		otherControlsConstraints.gridx = 0;
		otherControlsConstraints.gridy = 5 +0;
		//otherControlsConstraints.anchor = GridBagConstraints.LINE_START;
		otherControlsConstraints.gridwidth = 4;
		otherControlsConstraints.fill = GridBagConstraints.HORIZONTAL;
		
		JButton setStartRoomButton = new JButton("Set starting room");
		
		otherControlsPanel.add(setStartRoomButton, otherControlsConstraints);
		
		otherControlsConstraints.gridx = 4;
		otherControlsConstraints.gridy = 5 +0;
		//otherControlsConstraints.anchor = GridBagConstraints.FIRST_LINE_END;
		otherControlsConstraints.gridwidth = 6;
		
		otherControlsPanel.add(new JPanel(), otherControlsConstraints);//filler
		
		
		otherControlsConstraints.gridx = 0;
		otherControlsConstraints.gridy = 5 +1;
		otherControlsConstraints.gridwidth = 2;
		//otherControlsConstraints.anchor = GridBagConstraints.LINE_START;
		otherControlsPanel.add(new JLabel("Background Music:"), otherControlsConstraints);
		
		bgmTextArea = new JTextArea();
		bgmTextArea.setSize(new Dimension(60, 21));
		otherControlsConstraints.gridx = 2;
		otherControlsConstraints.gridy = 5 +1;
		otherControlsConstraints.gridwidth = 5;
		//otherControlsConstraints.anchor = GridBagConstraints.CENTER;
		otherControlsPanel.add(bgmTextArea, otherControlsConstraints);
		
		JButton bgmBrowseButton = new JButton("Browse...");
		otherControlsConstraints.gridx = 7;
		otherControlsConstraints.gridy = 5 +1;
		otherControlsConstraints.gridwidth = 3;
		//otherControlsConstraints.anchor = GridBagConstraints.LINE_END;
		otherControlsPanel.add(bgmBrowseButton, otherControlsConstraints);
		
		rainCheckbox = new JCheckBox("rain?");
		otherControlsConstraints.gridx = 0;
		otherControlsConstraints.gridy = 5 +2;
		otherControlsConstraints.gridwidth = 2;
		//otherControlsConstraints.anchor = GridBagConstraints.LAST_LINE_START;
		otherControlsPanel.add(rainCheckbox, otherControlsConstraints);
		
		JButton charactersButton = new JButton("Characters...");
		otherControlsConstraints.gridx = 2;
		otherControlsConstraints.gridy = 5 +2;
		otherControlsConstraints.gridwidth = 8;
		//otherControlsConstraints.anchor = GridBagConstraints.LAST_LINE_END;
		otherControlsPanel.add(charactersButton, otherControlsConstraints);
		
		
		
		
//		gbConstraints.gridwidth = GridBagConstraints.REMAINDER;
		gbConstraints.gridheight = 1;
		gbConstraints.weighty = 1;
		gbConstraints.gridx = 0;
		gbConstraints.gridy = 2;
		
		//gbLayout.setConstraints(mainPanel, gbConstraints);
		
//		mainPanel.add(otherControlsPanel, gbConstraints);
		
//		this.add(mainPanel, BorderLayout.CENTER);
		
	}
	*/
	
	private static JFrame editorFrame;
	private static MainEditorPanel mp;
	
	public static void main(String [] args) {
		
		
		editorFrame = new JFrame();

		mp = new MainEditorPanel(editorFrame);
		
		editorFrame.setContentPane(mp);
		
		editorFrame.setSize(new Dimension(400, 600));
		
//		editorFrame.addWindowListener(new WindowAdapter() {
//			@Override
//			public void windowClosing(WindowEvent e) {
//				if(editorFrame != null) {
//					editorFrame.dispose();
//				}
//				if(mp != null) {
//					mp.closeEverything();
//				}
//			}
//		});
		
		editorFrame.setVisible(true);
		
		
//		while(editorFrame.isVisible()) {
//			Thread.yield();
//		}
		
		
		
		
	}
	
	
	public ArrayList<String> getListOfRoomNames() {
		return roomList.getListOfRoomNames();
	}
	
	
	public RoomEditorPanel getRoomByName(String name) {
		return roomList.getRoomByName(name);
	}
	
	public void setAllRoomsToNotBeStart() {
		roomList.setAllRoomsToNotBeStart();
	}
	
	
	
	public void openStartRoomSelectionWizard() {
		
		JDialog theFrame = new JDialog();
		
		StartOfLevelRoomSelectWizard wizard = new StartOfLevelRoomSelectWizard(theFrame, this);
		
		theFrame.setContentPane(wizard);
		
		theFrame.setSize(new Dimension(400, 150));
		theFrame.setPreferredSize(new Dimension(400, 150));
		theFrame.setMaximumSize(new Dimension(400, 150));
		theFrame.setMinimumSize(new Dimension(400, 150));
		
		theFrame.setModal(true);
		theFrame.setVisible(true);
		
	}
	
	
	public void closeEverything() {
		roomList.closeAllWindows();
	}
	
	
	
	public void retrieveSoundFile(JTextField textArea, Window theEncasingFrame) {
		
		
		FileDialog fd = null;
		
		if(theEncasingFrame instanceof JDialog) {
			fd = new FileDialog((JDialog) theEncasingFrame, "Select Sound File", FileDialog.LOAD);
		} else {
			fd = new FileDialog((JFrame) theEncasingFrame, "Select Sound File", FileDialog.LOAD);
		}
		fd.setModal(true);
		
//		System.out.println("about to set visible to true!");
		
		fd.setVisible(true);
		
//		System.out.println("just set visible to true!");
		
		
		
		
		
		if(fd.getDirectory() != null && fd.getFile() != null) {
			
			
			textArea.setEditable(true);
			textArea.setText(fd.getDirectory() + fd.getFile());
			textArea.setEditable(false);
			textArea.repaint();
			
		} else {
			
			int confirm = JOptionPane.showConfirmDialog(null, "Use default music (Rainbow Factory by Glaze, instrumental)?", "Choose default music?", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
			
			if(confirm == JOptionPane.YES_OPTION) {
				textArea.setText("default");
			} else {
				
				confirm = JOptionPane.showConfirmDialog(null, "Use no music at all?  (Click 'no' for no change, yes for no music)", "Use no music at all", JOptionPane.YES_NO_OPTION);
				
				if(confirm == JOptionPane.YES_OPTION) {
					textArea.setText("");
				}
				
			}
			
		}
		
		fd.dispose();
		
	}
	
	public void save() {
//		System.out.println("now in save");
		
		
		boolean traversable = false;
		
		RoomEditorPanel startPanel = roomList.getStartRoomPanel();
		
		if(startPanel == null) {
//			System.out.println("start panel is null!");
		} else {
			traversable = startPanel.doesRouteStartToGoalExist(new HashSet<String>());
			
//			if(traversable) {
//				System.out.println("the path is traversible!");
//			} else {
//				System.out.println("the path is not traversible.");
//			}
		}
		
		
		
		
		
		FileDialog fd = new FileDialog(frame, "Select Save File", FileDialog.SAVE);
		
		fd.setVisible(true);
		
		if(fd.getDirectory() == null || fd.getFile() == null) {
			fd.dispose();
			return;
		}
		
		File saveFile = new File(fd.getDirectory() + fd.getFile());
//		if(saveFile.exists()) {
//			int result = JOptionPane.showConfirmDialog(this, "The file " + saveFile.getAbsolutePath() + "\nalready exists.  Overwrite?", "Confirm Overwrite", JOptionPane.WARNING_MESSAGE, JOptionPane.YES_NO_OPTION);
//			if(result != JOptionPane.YES_OPTION)
//				return;
//		}
		
		fd.dispose();
			
//		System.out.println("going to save, now...");
		
		try {
			
			StringBuffer reasonsLevelIsUnplayable = new StringBuffer();
			
			BufferedWriter out = new BufferedWriter(new FileWriter(saveFile));
			
			out.write("file");
			
			out.newLine();
			out.newLine();
			
			out.write("levelName:" + levelName.getText().trim());
			out.newLine();
			out.write("music:" + bgmTextArea.getText().trim());
			out.newLine();
			
			if(rainCheckbox.isSelected()) {
				out.write("rain");
			} else {
				out.write("norain");
			}
			out.newLine();
			
			if(bgmTextArea.getText() == null || bgmTextArea.getText().trim().length() == 0) {
				out.write("music:nomusic");
			} else {
				out.write("music:" + bgmTextArea.getText());
			}
			out.newLine();
			
			
			out.newLine();
			
			String startArray[] = roomList.retrieveStartOfGameData();
			if(startArray == null) {
				reasonsLevelIsUnplayable.append("There is no starting point to this level.\n");
			} else {
				for(String s : startArray) {
					out.write(s);
					out.newLine();
				}
				out.newLine();
			}
			
			
			for(int i = 0; i < roomList.getRoomCount(); i++) {
				roomList.getRoom(i).getPanel().writeRoomToFile(out);
			}
			
			
			
			if(this.characterList != null && this.characterList.getCharacterCount() > 0) {
				
				out.write("characters:");
				out.newLine();
				for(CharacterListItem cli : characterList.getCharacters()) {
					cli.writeOutCharacterToFile(out);
				}
				out.write("/characters");
			}
			
			
			//after everything else
			out.flush();
			out.close();
			
			
			
			if(traversable) {
				
				int shouldPack = JOptionPane.showConfirmDialog(null, "<html>This program has detected that this level has a complete<br>path from the start to the goal!<br><br>Do you want to PACK this level so that it can be easily<br>copied to other computers?","Pack level?", JOptionPane.YES_NO_OPTION);
				
				if(shouldPack == JOptionPane.YES_OPTION) {
//					System.out.println("pack away!");
					
					
					FileDialog fd2 = new FileDialog(frame, "Select Pack File", FileDialog.SAVE);
					
					FilenameFilter fnf = new FilenameFilter() {
						
						@Override
						public boolean accept(File dir, String name) {
							if(name.contains(".lvlpack"))
								return true;
							return false;
						}
					};
					
					fd2.setFilenameFilter(fnf);
					
					
					fd2.setVisible(true);
					
					if(fd2.getFile() == null || fd2.getDirectory() == null) {
						fd2.dispose();
						return;
					}
					
					File packFile = new File(fd2.getDirectory() + fd2.getFile());
					
					fd2.dispose();
					
					
					PackerUnpacker packer = new PackerUnpacker();
					boolean success = packer.pack(saveFile.getAbsolutePath(), packFile.getAbsolutePath());
					
					if(success) {
						JOptionPane.showMessageDialog(null, "Level is now packed!","Pack complete!",JOptionPane.INFORMATION_MESSAGE);
					}
					
				}
				
				
			}
			
			
			
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
			JOptionPane.showMessageDialog(null, "Error occurred during save: " + e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
		}
		
		
	}
	
	public void load(boolean showConfirmDialog, String theLoadFileName) {
//		System.out.println("now in load");
		
		
		int choice = Integer.MIN_VALUE;
		
		if(showConfirmDialog)
			choice = JOptionPane.showConfirmDialog(frame, "Loading something up will clear out everything that has been loaded so far.  Continue?","Confirm load", JOptionPane.WARNING_MESSAGE, JOptionPane.OK_CANCEL_OPTION);
		
		if(choice == JOptionPane.CANCEL_OPTION)
			return;
		
		
		String loadFileName = theLoadFileName;
		
		
		if(loadFileName == null) {
			
			FileDialog fd = new FileDialog(frame, "Select Load File", FileDialog.LOAD);
			
			fd.setVisible(true);
			
			if(fd.getDirectory() == null || fd.getFile() == null) {
				fd.dispose();
				return;
			}
			
			
			loadFileName = fd.getDirectory() + fd.getFile();
			
			fd.dispose();
		}
		
		File loadFile = new File(loadFileName);
		

		BusyPanel.showWaitBox(BusyPanel.LOAD, this);
		
		
		ArrayList<RoomListItem> newRoomList = new ArrayList<RoomListItem>();
		String levelName = null;
		String musicName = null;
		String startRoomName = null;
		int startRoomXPos = -1;
		int startRoomYPos = -1;
		
		RoomListItem tempRoomListItem;
		
		HashMap<String, RoomEditorPanel> roomNamesToRooms = new HashMap<String, RoomEditorPanel>();
		
		rainCheckbox.setSelected(true);
		
		try {
			BufferedReader in = new BufferedReader(new FileReader(loadFile));
			
			String inputter;
			
			boolean firstRow = true;
			
			while((inputter = in.readLine()) != null) {
				
				if(firstRow) {
					firstRow = false;
					if(inputter.trim().equalsIgnoreCase("pack")) {
						
						BusyPanel.hideWaitBox();
						
						JOptionPane.showMessageDialog(null, "<html>The editor has detected that this is a packed file!<br>Please select a directory to export the contents of the pack to.</html>","Packed file", JOptionPane.INFORMATION_MESSAGE);
						
						//TODO:  get a file dialog here
						
						JFileChooser fileChooser = new JFileChooser();
						fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
						
						fileChooser.setMultiSelectionEnabled(false);
						
						int response = fileChooser.showSaveDialog(this);
						
						if(response == JFileChooser.CANCEL_OPTION) {
							BusyPanel.hideWaitBox();
							return;
						}
							
						String targetDir = fileChooser.getSelectedFile().getAbsolutePath();
						
						PackerUnpacker unpacker = new PackerUnpacker();
						
						in.close();
						
						BusyPanel.hideWaitBox();
						
						
						boolean unpackingWorked = unpacker.unpack(targetDir, loadFileName);
						
						
						BusyPanel.hideWaitBox();
						
						
						if(unpackingWorked) {
							//JOptionPane.showMessageDialog(null, "<html>Unpacking was successful!<br><br>Now that the file has been unpacked,<br>please find the level file so it can be loaded!</html>","Unpacking succeeded",JOptionPane.INFORMATION_MESSAGE);
							
							
							load(false, unpacker.getMainFileName());
							
							
						}
						
						return;
					}
				}
				
				if(inputter.contains("#")) {
					continue;
				} else if(inputter.contains("levelName:")) {
					levelName = inputter.substring(10).trim();
				} else if(inputter.contains("music:")) {
					musicName = inputter.substring(6).trim();
				} else if(inputter.contains("firstRoom:")) {
					startRoomName = inputter.substring(10).trim();
				} else if(inputter.contains("levelStartSpawnX:")) {
					startRoomXPos = Integer.parseInt(inputter.substring(17).trim());
				} else if(inputter.contains("levelStartSpawnY:")) {
					startRoomYPos = Integer.parseInt(inputter.substring(17).trim());
				} else if(inputter.contains("room:")) {
					tempRoomListItem = new RoomListItem(in, this);
					newRoomList.add(tempRoomListItem);
					roomNamesToRooms.put(tempRoomListItem.getPanel().getStaticBlockFactory().getRoomName(), tempRoomListItem.getPanel());
				} else if(inputter.contains("firstRoom:")) {
					startRoomName = inputter.substring(10);
				} else if(inputter.contains("norain")) {
					rainCheckbox.setSelected(false);
				} else if(inputter.contains("rain")) {
					rainCheckbox.setSelected(true);
				} else if(inputter.contains("characters:")) {
					this.characterList.loadCharactersFromFile(in);
				}
				
			}
			
			
			in.close();
			//if we get to this point, it's time to make some changes
			
			
			//now, need to go through the list of rooms and take care of their 
			Set<String> roomNamesSet = roomNamesToRooms.keySet();
			RoomEditorPanel tempSourcePanel = null;
			HashMap<String, DoorLoadData> tempDoorLoadMap = null;
			DoorLoadData tempDLD = null;
			Set<String> dldSet = null;
			String destRoomName = null;
			RoomEditorPanel tempDestPanel = null;
			DoorSourcePaletteObject tempSourcePaletteObject = null;
			
//			System.out.println("about to try to add all the doors' data.  roomNamesSet is of size: " + roomNamesSet.size());
			
//			for(String roomName : roomNamesSet) {
//				System.out.println("a room name:  <<" + roomName + ">>");
//				if(getRoomByName(roomName) == null) {
//					System.out.println("and that one was null??  It contains null?!  Are you kidding?!");
//				} else {
//					System.out.println("That room was non-null.  Good.");
//				}
//			}
			
			
			for(String roomName : roomNamesSet) {
				
				tempSourcePanel = roomNamesToRooms.get(roomName);
				
				
				tempDoorLoadMap = tempSourcePanel.getDoorLoadPalette();
				
				dldSet = tempDoorLoadMap.keySet();
				
//				System.out.println("on room " + roomName + "; dldSet is of size: " + dldSet.size());
				
				for(String dldKey : dldSet) {
					
					tempDLD = tempDoorLoadMap.get(dldKey);
					
					destRoomName = tempDLD.getDestinationRoom();
					tempDestPanel = roomNamesToRooms.get(destRoomName);
					if(tempDestPanel == null) {
//						System.out.println("odd; tempDestPanel was null!");
						continue;
					}
					
					//got the source and destination panels...time to add a palette object to the source panel!
					tempSourcePaletteObject = tempSourcePanel.getEditorPalette().addDoorReturnSourcePaletteObject(tempDLD, tempDestPanel);
					tempSourcePanel.addSourceDoors(tempDLD.getSourcePoints(), tempSourcePaletteObject);
					
//					System.out.println("just added a door in source room " + tempSourcePanel.getStaticBlockFactory().getRoomName());
					
				}
				
				
				
				//incomplete doors
				tempDoorLoadMap = tempSourcePanel.getIncompleteDoorLoadPalette();
				
				dldSet = tempDoorLoadMap.keySet();
				
				for(String dldKey : dldSet) {
					tempDLD = tempDoorLoadMap.get(dldKey);
					
					destRoomName = tempDLD.getDestinationRoom();
					tempDestPanel = roomNamesToRooms.get(destRoomName);
					if(tempDestPanel == null) {
//						System.out.println("odd; tempDestPanel was null!");
						continue;
					}
					
					//got the source and destination panels...time to add a palette object to the source panel!
					tempSourcePaletteObject = tempSourcePanel.getEditorPalette().addDoorReturnSourcePaletteObject(tempDLD, tempDestPanel);
					tempSourcePanel.addSourceDoors(tempDLD.getSourcePoints(), tempSourcePaletteObject);
					
				}
				
				
				
				//commentary doors
				tempDoorLoadMap = tempSourcePanel.getCommentDoorLoadPalette();
				
				dldSet = tempDoorLoadMap.keySet();
				
//				System.out.println("on room " + roomName + "; dldSet is of size: " + dldSet.size());
				
				for(String dldKey : dldSet) {
					
					tempDLD = tempDoorLoadMap.get(dldKey);
					
					destRoomName = tempDLD.getDestinationRoom();
					tempDestPanel = roomNamesToRooms.get(destRoomName);
					if(tempDestPanel == null) {
//						System.out.println("odd; tempDestPanel was null!");
						continue;
					}
					
					//got the source and destination panels...time to add a palette object to the source panel!
					tempSourcePaletteObject = tempSourcePanel.getEditorPalette().addCommentDoorReturnSourcePaletteObject(tempDLD, tempDestPanel);
					tempSourcePanel.addSourceCommentDoors(tempDLD.getSourcePoints(), tempSourcePaletteObject);
					
//					System.out.println("just added a comment door in source room " + tempSourcePanel.getStaticBlockFactory().getRoomName());
					
				}
				
				
				//incomplete comment doors
				tempDoorLoadMap = tempSourcePanel.getIncompleteCommentDoorLoadPalette();
				
				dldSet = tempDoorLoadMap.keySet();
				
				for(String dldKey : dldSet) {
					tempDLD = tempDoorLoadMap.get(dldKey);
					
					destRoomName = tempDLD.getDestinationRoom();
					tempDestPanel = roomNamesToRooms.get(destRoomName);
					if(tempDestPanel == null) {
//						System.out.println("odd; tempDestPanel was null!");
						continue;
					}
					
					//got the source and destination panels...time to add a palette object to the source panel!
					tempSourcePaletteObject = tempSourcePanel.getEditorPalette().addCommentDoorReturnSourcePaletteObject(tempDLD, tempDestPanel);
					tempSourcePanel.addSourceCommentDoors(tempDLD.getSourcePoints(), tempSourcePaletteObject);
					
				}
				
			}
			
			
			if(startRoomName != null) {
				//find the starting room in the list, and put the starting point in there!
				
				tempSourcePanel = roomNamesToRooms.get(startRoomName);
				tempSourcePanel.setStartRoom(true);
				
				LevelStartPaletteObject lspo = tempSourcePanel.getEditorPalette().getLevelStartPaletteObject();
				LevelStartScreenObject lsso = (LevelStartScreenObject) lspo.create(startRoomXPos, startRoomYPos, this);
				
				tempSourcePanel.getWidgetLayerScreenObjects().add(lsso);
				
			}
			
			if(levelName == null) {
				levelName = "";
			}
			this.levelName.setText(levelName);
			
			if(musicName == null || musicName.equalsIgnoreCase("nomusic")) {
				musicName = "";
			}
			this.bgmTextArea.setText(musicName);
			
			
			
			roomList.closeAllWindows();
			roomList.removeAllRooms();
			
			for(RoomListItem rli : newRoomList) {
//				if(rli.getPanel() == null) {
//					System.out.println("panel is null?");
//				} else if(rli.getPanel().getStaticBlockFactory() == null) {
//					System.out.println("odd; the factory shouldn't have been null...");
//				} else {
//					System.out.println("what's null?");
//				}
				rli.setName(rli.getPanel().getStaticBlockFactory().getRoomName());
				roomList.addRoom(rli);
			}
			
//			System.out.println("about to call updateAllIconsAndColors...");
			roomList.updateAllIconsAndColors();
//			System.out.println("called updateAllIconsAndColors...");
			
		} catch (Exception e) {
//			e.printStackTrace();
			JOptionPane.showMessageDialog(frame, "There was an exception: " + e.getMessage(),"Error while loading", JOptionPane.ERROR_MESSAGE);
		}
		
//		System.out.println("it should've stopped, now...");
		
		BusyPanel.hideWaitBox();

//		System.out.println("it should've stopped, now...2");
		
	}
	
	public void newFile() {
//		System.out.println("now in newFile");
		
		int result = JOptionPane.showConfirmDialog(this, "Do you really want to clear out all data?", "Confirm New", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
		if(result == JOptionPane.NO_OPTION)
			return;
		
		roomList.closeAllWindows();
		roomList.removeAllRooms();
		characterList.removeAllCharacters();
		
//		roomList = new RoomList(this);
//		scrollPane.add(roomList);
		this.repaint();
		
	}
	
	public void quit() {
//		System.out.println("now in quit");
		
		int result = JOptionPane.showConfirmDialog(this, "Do you really want to exit?", "Confirm Exit", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
		if(result == JOptionPane.NO_OPTION)
			return;
		
		roomList.closeAllWindows();
		
		frame.dispose();
		
		Frame fArray[] = Frame.getFrames();
		
//		System.out.println("count of active frames: " + (fArray == null ? "null" : Integer.toString(fArray.length)));
		
		BusyPanel.endAll();
		
		System.exit(0);
	}
	
	
	public boolean validateRoomName(String oldName, String newName) {
		
		
		int indexOfOldName = -1;
		
		if(oldName != null) {
			
			for(int i = 0; i < roomList.getRoomCount(); i++) {
				if(roomList.getRoom(i).getName() != null && roomList.getRoom(i).getName().equals(oldName)) {
					indexOfOldName = i;
					i = roomList.getRoomCount();
				}
			}
			
		}
		
//		System.out.println("oldname is: " + oldName + ", index: " + indexOfOldName);
		
		
		for(int i = 0; i < roomList.getRoomCount(); i++) {
			
			if(i == indexOfOldName)
				continue;
			
			if(roomList.getRoom(i).getName().equals(newName)) {
				return false;
			}
			
		}
		
		
		return true;
		
	}
	
	
	public void openBrowserToTutorialsScreen(String url) {
		
		int input = JOptionPane.showConfirmDialog(this, "<htmL>Do you want this program to open a browser to the Youtube tutorial<br>videos for the level editor?</html>","Jump to Youtube tutorial videos?", JOptionPane.YES_NO_OPTION);
		
		if(input== JOptionPane.NO_OPTION)
			return;
		
		if(!Desktop.isDesktopSupported()) {
			
			JOptionPane.showMessageDialog(null, "<html>Sorry, but on your computer, there's no feature for opening browser windows from Java programs.<br>" +
					"You'll need to open one yourself and go to "+url+"</html>");
			
		} else {
			Desktop desktop = Desktop.getDesktop();
	        if (desktop.isSupported(Desktop.Action.BROWSE)) {
	        	try {
	        		desktop.browse(new URI(url));
	        	} catch(Exception e) {
	        		JOptionPane.showMessageDialog(null, PonyPanel.formatStackTrace(e),"Error while trying to navigate to web page", JOptionPane.ERROR_MESSAGE);
	        	}
	        } else {
	        	JOptionPane.showMessageDialog(null, "<html>Sorry, but on your computer, there isn't a feature for opening browser windows from Java programs.<br>" +
						"You'll need to open one yourself and go to "+url+"</html>");
	        }
		}
		return;
		
	}
	
	
	
	public class ShowVersionHistoryPanel extends JDialog {
		
		private String fullText;
		
		public ShowVersionHistoryPanel() {
			
			try {
				
				BufferedReader in = new BufferedReader(new InputStreamReader(MainEditorPanel.class.getResource("/versionHistory.txt").openStream()));
				
				
				StringBuffer buf = new StringBuffer();
				
				String inputter;
				while((inputter = in.readLine()) != null) {
					buf.append(inputter);
					buf.append("\n");
				}
				
				in.close();
				
				fullText = buf.toString();
				
				
			} catch(Exception e) {
				fullText = "Error while trying to read the version history resource file:\n"
						+ PonyPanel.formatStackTrace(e);
			}
			
			
			JTextArea textArea = new JTextArea();
			textArea.setEditable(false);
			textArea.setLineWrap(true);
			textArea.setText(fullText);
			
			
			JScrollPane scrollPanel = new JScrollPane(textArea);
			scrollPanel.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
			
			this.setContentPane(scrollPanel);
			
			textArea.setCaretPosition(0);
			
			this.addWindowListener(new WindowAdapter() {
				@Override
				public void windowClosed(WindowEvent arg0) {
					disposeMe();
				}
			});
			
		}
		
		
		public void disposeMe() {
			this.dispose();
		}
		
	}
	
	public void showVersionHistoryPopup() {
		
		ShowVersionHistoryPanel dialog = new ShowVersionHistoryPanel();
		
		dialog.setModal(true);
		dialog.setSize(new Dimension(500, 400));
		
		dialog.setVisible(true);
		
	}
}
